	function PLOT_IMPULSE_RESPONSE_Z(h)
 
	%	Plots the impulse response, h(nT) for a discrete-time filter. 
	%
	%	Toolbox for DIGITAL FILTERS USING MATLAB

	% 	Author: 		Lars Wanhammar 2005-05-04
	% 	Modified by: 	2014-07-20 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1 
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com

	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================
	color = 'b';			% Set color
	linetype = '-';
	x = [0:length(h)-1];
	x = x(:)';
    h = h(:)';
	xx = [x; x];
	yy = [zeros(1, length(x)); h];
	ax = newplot;
	hold on;
	aym = 0.1; %  This may be changed to get a neater plot
	plot(x, h, [color '.'], xx, yy, [color linetype],'linewidth', lw)
	stem(x, h,'filled')
	color = 'k';
	set(ax,'ylim',[floor(10*(min(h)-aym))/10 floor(10*(max(h)+aym))/10], ...
	'Xcolor', color,'fontsize',fs,'linewidth', 1, 'fontname', fn);
	set(ax,'xlim',[x(1)-1 x(end)+1], 'Ycolor', color);
	set(get(ax,'xlabel'),'string','{\itn}','fontsize',fs,'fontname', fn);
	set(get(ax,'ylabel'),'string','{\ith}({\itnT})','fontsize', fs,'fontname', fn);
	grid on;
	hold off;
	box on;	
